
Class Game Extends Window

	Public

	Global GameScene:Scene ' Should probably refer to a Level.Scene
	
 	Global MainCamera:GameCamera
	Global CurrentLevel:Level
	Global Player:Rocket

	Method New (title:String, width:Int, height:Int, flags:WindowFlags)
		Super.New (title, width, height, flags)
	End

	Method OnCreateWindow () Override

		InitLevel ("asset::height.png")

		AssignGlobalRefs ()						' Set global references to current level's player and camera

		Mouse.PointerVisible = False

	End
	
	Function AssignGlobalRefs ()
		Game.Player		= CurrentLevel.Player
		Game.MainCamera	= CurrentLevel.MainCamera
	End

	Method InitLevel (level:String)

		GameScene				= Scene.GetCurrent ()
		
'		GameScene.UpdateRate = 480.0
		
		GameScene.AmbientLight	= Color.White * 0.75
		GameScene.ClearColor	= Color.Sky * 0.75	
		GameScene.World.Gravity = GameScene.World.Gravity * New Vec3f (1.0, 0.5, 1.0) ' Half normal gravity
		GameScene.CSMSplits		= New Float [] (2, 4, 16, 256)
		
		' VR
		
		If VR_MODE
			renderer = New VRRenderer
		Endif
				
		CurrentLevel = New Level (level)	' Create game level

		GameScene.Update ()					' Fixes missing Player on directional input at startup;
											' Believe body needs update before applying impulse!

		' Can't start these in Release mode without first updating Scene, or they don't appear!
		
		' Hmm, basically as per GameScene.Update comment above...
		
		SpaceGem.Start ()
		
	End
	
	Method UpdateGame ()

		SpaceGem.Update ()
		
		If CurrentLevel.Complete ()
			' Spawn orb to collect!
			Notify ("Super Thrusting Game!", "Well done! Game over!")
			App.Terminate ()
		Endif
		
		AppControl				()			' Application controls (Esc to quit, etc)
		Player.Control			()			' Rocket controls
		
		MainCamera.Update		(Player)	' Update camera, follow player
		SpaceGem.Update			()			' Update gems
		SmokeParticle.Update	()			' Update smoke
		
		If Not Player.Alive
			If HUD.Blackout () = 1.0
				CurrentLevel.Reset ()
				GameScene.Update ()				' Needed or else physics fails...
			Endif
		Else
			HUD.ResetBlackout ()
		Endif
		
	End

	Method AppControl ()

		If Keyboard.KeyHit (Key.Escape)
			App.Terminate ()
		Endif

		If Keyboard.KeyHit (Key.R) Or (Player.Joy And Player.Joy.Attached And Player.Joy.ButtonPressed (7))
			CurrentLevel.Reset ()
			GameScene.Update ()			' Needed or else physics fails...
		Endif

		Temp.Controls ()			' Debug/temp controls in Temp class
		
	End
	
	Method OnRender (canvas:Canvas) Override

		UpdateGame ()
		
		RequestRender ()

		If VR_MODE
		
			renderer.Update ()
			
			MainCamera.Camera3D.SetBasis	(renderer.HeadMatrix.m, True)
			MainCamera.Camera3D.SetPosition	(renderer.HeadMatrix.t, True)
		
		Endif
		
		GameScene.Update ()
		GameScene.Render (canvas)

		If VR_MODE
		
			' Scaling not right on monitor display...
			
			canvas.DrawRect	(0, Height, Width, -Height, renderer.LeftEyeImage)
			canvas.Scale	(Width / App.ActiveWindow.Width, Height / App.ActiveWindow.Height)
		
		Endif
			
		HUD.RenderText (canvas)
		
	End

	Private
	
	' VR
	
	Field renderer:VRRenderer
		
End
